//================================================================================================
// This is the superclass of all thnigs flyable, made by WCCC, help from Anna, AKA Wild or WildCat
// Additional help from all those guys who supported me back at fgs clan forum
//================================================================================================
class MSFlyables extends MSDrivables;

var() bool HasBombs;
var() int MaxBombs;
var() float BombTime, BombTimer;
var int BombsLeft;
var() class<Projectile> BombType;
var MenuUIFlyingWindow _FlyingScreen; //our current driving screen
var float StallTimer; //used for disabling flight
var class<MenuUIFlyingWindow> FlyingScreenType; //used for custom window types
var class<MenuUIFlyingWindow> MPFlyingScreenType; //used for custom window types in mp
var() rotator BombRotation;
var rotator DriverRotation;
var int ViewPointNum;
var bool bCrashed; //used to tell if its already plopped out of the sky

replication
{
     reliable if (Role == ROLE_Authority)
         BombTime, MaxBombs, HasBombs, BombsLeft, StallTimer, bCrashed, BombType, ViewPointNum, DriverRotation;
     reliable if (Role < ROLE_Authority)
         BombTimer, BlowTheLoad, MSFlyUpward, MSFlyDownward, SwitchViewPos;
}

simulated function PostBeginPlay()
{
 Super.PostBeginPlay();

 if (Level.NetMode != NM_Standalone)
 {
  FlyingScreenType = MPFlyingScreenType;
  AmbientSound = None;
 }
 BombsLeft = MaxBombs; //start off with a full load o' bombs
}

simulated function EjectPassenger()
{
 if (MSCarPassenger != None)
 {
    MSCarPassenger.SetLocation(Location + (PassengerDump >> Rotation)); 
    MSCarPassenger = None;
   if (IsInState('MSDriving2'))
    GoToState('MSDriving1');
 }
}

simulated function StopMSDriving()
{
    MSCarDriver.SetLocation(Location + (DriverDump >> Rotation)); 
    MSCarDriver.StartWalk();
//    MSCarDriver.ViewTarget = None;
//    MSCarDriver.bBehindView = False;
    MSCarDriver = None;
    SetOwner(None);
    /*if (MSCarPassenger != None)
    {
     MSCarPassenger.SetLocation(Location + (PassengerDump >> Rotation)); 
     MSCarPassenger = None;
    }*/
//    bBlockActors = True;
//    bBlockPlayers = True;
    //_FlyingScreen.root.PopWindow();
    if (Level.NetMode == NM_Standalone)
     _flyingScreen = None;
   if (!IsInState('Exploding'))
   {
    SetPhysics(PHYS_Falling); //added because the car floats in the air otherwise...
    GoToState('Active');
   }
    return;  
}

simulated function HandleWaterDriving()
{
    if (MSCarDriver != None)
    {
MSCarDriver.SetLocation(Self.Location + vect(0,0,1) * (CollisionHeight / 2 + MSCarDriver.CollisionHeight + 48)); 
//    MSCarDriver.ViewTarget = None;
//    MSCarDriver.bBehindView = False;
    MSCarDriver.StartWalk();
    MSCarDriver = None;
    if (MSCarPassenger != None)
    {
     MSCarPassenger.SetLocation(Location + (PassengerDump >> Rotation)); 
     MSCarPassenger = None;
    }
    bBlockActors = True;
    bBlockPlayers = True;
//   if (Level.NetMode == NM_StandAlone)
//    _FlyingScreen.root.PopWindow();

    if (Level.NetMode == NM_Standalone)
     _flyingScreen = None;
    SetPhysics(PHYS_Falling); //added because the car floats in the air otherwise...
    bInvincible = false;
    GoToState('Active');
    Explode(Location);
   }
}

simulated function HandleDyingDriver()
{
}

simulated function HandleLivingDriver()
{
    if ((MSCarDriver != None) && (!MSCarDriver.IsInState('Dying')))  //this makes the player follow the car
    {
       MSCarDriver.ClientSetLocation(Location + (DriverPos >> Rotation), Rotation + DriverRotation);
       MSCarDriver.SetLocation(Location + (DriverPos >> Rotation));
     if (MSCarDriver.Physics != PHYS_None)
       MSCarDriver.SetPhysics(PHYS_None);
    }
}

simulated function HandlePassenger()
{
    if (MSCarPassenger != None)
    {
     if (MSCarPassenger.IsInState('Dying'))
      MSCarPassenger = None;
     else
     {
      UpdatePassengerPos();
     }
    }
}

simulated function SwitchViewPos()
{
 if (ViewPointNum == 0)
 {
  DriverRotation = rot(-8330,0,0);
  ViewPointNum = 1;
  return;
 }
 if (ViewPointNum == 1)
 {
  DriverRotation = rot(-16660,0,0);
  ViewPointNum = 2;
  return;
 }
 if (ViewPointNum == 2)
 {
  DriverRotation = rot(-33320,0,0);
  ViewPointNum = 3;
  return;
 }
 if (ViewPointNum == 3)
 {
  DriverRotation = rot(0,0,0);
  ViewPointNum = 0;
  return;
 }
}

state MSDriving1
{
function Tick(float DeltaTime)
{
  local Actor Other;
  local int X, Y;
//  local vector PassengerDump;
//  local rotator WORKDAMMIT;

//  if (MSCarDriver != None)
//  {
//    SetLocation(MSCarDriver.Location + vect(0,0,1) * CollisionHeight / 2);
//a little calculation to measure how fast the car is going, used for damage calculation.
//    MSCarSpeed = (MSCarDriver.Location.X - MSCarDriver.OldLocation.X) + (MSCarDriver.Location.Y - MSCarDriver.OldLocation.Y);
 if ((LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos != LRPGPos))
 {
   LeftGunPos = LRPGPos;
   RightGunPos = RRPGPos;
 }
 if ((!LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos == LRPGPos))
 {
   LeftGunPos = Default.LeftGunPos;
   RightGunPos = Default.RightGunPos;
 }

    MSCarSpeed = VSize(Velocity) / 21.5;
    if (MSCarSpeed < 1) MSCarSpeed = 0;

    if ((bUseGas) && (GasLeft > 0))//if we are using gas
    {                        //subtract time from our gas
       GasLeft -= DeltaTime * 1515.151515; //helicopters are constantly using gas, so i give them a maxmimum of 11 minutes
    }

    if ((bUseGas) && (GasLeft <= 0) && (!bCrashed))
    {
     bCrashed = True;
     SetPhysics(PHYS_Falling); //its a no brainer that aircraft fall when they're out of gas
     AmbientSound = None; //dont play a motor sound if the motor isnt running
     bInvincible = False;
     LoopAnim('Still');
    }

    if (!bCrashed)
     LoopAnim('Fly');

 /*   if (Region.Zone.bWaterZone)
    {
     HandleWaterDriving();
    }*/

    if ((Region.Zone.IsA('RefuelingZone')) && (GasLeft < TopGas * 100000))
     GasLeft += DeltaTime * TopGas * 10000;

    if (GasLeft > TopGas * 100000)
     GasLeft = TopGas * 100000;

    if (LastGasTimer > 0) //if the gas timer isnt too low, decrease it
    {
          LastGasTimer -= DeltaTime;
          bStillDriving = True;
    }
  
    if (StallTimer > 0) //if the stall timer isnt too low, decrease it
    {
          StallTimer -= DeltaTime;
    }

    if (EBrakeTimer > 0)
     EBrakeTimer -= DeltaTime;

    if (LastGasTimer <= 0) //if its been too long, assume we've stopped driving
       if (bStillDriving)
          bStillDriving = False;

                         //UPDATE: added shit for drifting
    if ((!bStillDriving) && (EBrakeTimer <= 0)) //projectile physics dont slow themselves, so lets do that automatically
       if (Velocity != vect(0,0,0))
          Velocity -= Velocity / 20 * 0.4 * BrakeStrength; //minus __% of the speed, maximum of 20%

    	if (BombTimer > 0)
	BombTimer -= DeltaTime;

    	if (ShotTimer > 0)
	ShotTimer -= DeltaTime;

     HandleDyingDriver();
    
    // HandlePassenger();

     HandleLivingDriver();

     CheckForRoadKill(Other);

    if ((MSCarDriver != None) && (_flyingscreen != None))
     _flyingscreen.SetMessageText(GetDrivingStats());
//  }  
}
	function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		local float avg;

		if (bStatic || bInvincible)
			return;

		if ((DamageType == 'TearGas') || (DamageType == 'PoisonGas') || (DamageType == 'Radiation'))
			return;

		if ((DamageType == 'EMP') || (DamageType == 'NanoVirus') || (DamageType == 'Shocked'))
			return;

		if (DamageType == 'HalonGas')
			ExtinguishFire();

		if ((DamageType == 'Burned') || (DamageType == 'Flamed'))
		{
			if (bExplosive)		// blow up if we are hit by fire
				HitPoints = 0;
			else if (bFlammable && !Region.Zone.bWaterZone)
			{
				GotoState('Burning');
				return;
			}
		}

		if (Damage >= minDamageThreshold)
			HitPoints -= Damage;
		else
		{
			// sabot damage at 50%
			// explosion damage at 25%
			if (damageType == 'Sabot')
				HitPoints -= Damage * 0.5;
			else if (damageType == 'Exploded')
				HitPoints -= Damage * 0.25;
		}

		if (HitPoints > 0)		// darken it to show damage (from 1.0 to 0.1 - don't go completely black)
		{
			ResetScaleGlow();
		}
		else	// destroy it!
		{
			DropThings();

			// clear the event to keep Destroyed() from triggering the event
			Event = '';
			avg = (CollisionRadius + CollisionHeight) / 2;
			Instigator = EventInstigator;
			if (Instigator != None)
				MakeNoise(1.0);

			if (fragType == class'WoodFragment')
			{
				if (avg > 20)
					PlaySound(sound'WoodBreakLarge', SLOT_Misc,,, 512);
				else
					PlaySound(sound'WoodBreakSmall', SLOT_Misc,,, 512);
				AISendEvent('LoudNoise', EAITYPE_Audio, , 512);
			}

			// if we have been blown up, then destroy our contents
			// CNN - don't destroy contents now
//			if (DamageType == 'Exploded')
//			{
//				Contents = None;
//				Content2 = None;
//				Content3 = None;
//			}

			if (bExplosive)
			{
				Frag(fragType, Momentum * explosionRadius / 4, avg/35.0, avg/10 + 1);
				Explode(HitLocation);
			}
			else
				Frag(fragType, Momentum / 10, avg/20.0, avg/5 + 1);
		}
          	if (Damage >= 1)
		{
                        if (DamageSpots[DamageSpotCount] != None)
                         DamageSpots[DamageSpotCount].DelayedDestroy();

		    	DamageSpots[DamageSpotCount] = Spawn(class'ParticleGenerator', Self,, HitLocation);
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Sabot'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.123;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = Damage / 50;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType != 'Sabot') && (DamageType != 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.09;
				DamageSpots[DamageSpotCount].checkTime = 0.035;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
                	if ((Damage >= 25) || (HitPoints < Default.HitPoints / 2))
			{
				Frag(fragType, Momentum / 10, avg/30.0, avg/5 + 1);
			}
		}
	}
}

state MSDriving2
{
function Tick(float DeltaTime)
{
  local Actor Other;
  local int X, Y;
//  local vector PassengerDump;
//  local rotator WORKDAMMIT;

//  if (MSCarDriver != None)
//  {
//    SetLocation(MSCarDriver.Location + vect(0,0,1) * CollisionHeight / 2);
//a little calculation to measure how fast the car is going, used for damage calculation.
//    MSCarSpeed = (MSCarDriver.Location.X - MSCarDriver.OldLocation.X) + (MSCarDriver.Location.Y - MSCarDriver.OldLocation.Y);
 if ((LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos != LRPGPos))
 {
   LeftGunPos = LRPGPos;
   RightGunPos = RRPGPos;
 }
 if ((!LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos == LRPGPos))
 {
   LeftGunPos = Default.LeftGunPos;
   RightGunPos = Default.RightGunPos;
 }

    MSCarSpeed = VSize(Velocity) / 21.5;
    if (MSCarSpeed < 1) MSCarSpeed = 0;

    if ((bUseGas) && (GasLeft > 0))//if we are using gas
    {                        //subtract time from our gas
       GasLeft -= DeltaTime * 1515.151515; //helicopters are constantly using gas, so i give them a maxmimum of 11 minutes
    }

    if ((bUseGas) && (GasLeft <= 0) && (!bCrashed))
    {
     bCrashed = True;
     SetPhysics(PHYS_Falling); //its a no brainer that aircraft fall when they're out of gas
     AmbientSound = None; //dont play a motor sound if the motor isnt running
     bInvincible = False;
     LoopAnim('Still');
    }

    if (!bCrashed)
     LoopAnim('Fly');

    /*if (Region.Zone.bWaterZone)
    {
     HandleWaterDriving();
    }*/

    if ((Region.Zone.IsA('RefuelingZone')) && (GasLeft < TopGas * 100000))
     GasLeft += DeltaTime * TopGas * 10000;

    if (GasLeft > TopGas * 100000)
     GasLeft = TopGas * 100000;

    if (LastGasTimer > 0) //if the gas timer isnt too low, decrease it
    {
          LastGasTimer -= DeltaTime;
          bStillDriving = True;
    }
  
    if (StallTimer > 0) //if the stall timer isnt too low, decrease it
    {
          StallTimer -= DeltaTime;
    }

    if (EBrakeTimer > 0)
     EBrakeTimer -= DeltaTime;

    if (LastGasTimer <= 0) //if its been too long, assume we've stopped driving
       if (bStillDriving)
          bStillDriving = False;

                         //UPDATE: added shit for drifting
    if ((!bStillDriving) && (EBrakeTimer <= 0)) //projectile physics dont slow themselves, so lets do that automatically
       if (Velocity != vect(0,0,0))
          Velocity -= Velocity / 20 * 0.4 * BrakeStrength; //minus __% of the speed, maximum of 20%

    	if (BombTimer > 0)
	BombTimer -= DeltaTime;

    	if (ShotTimer > 0)
	ShotTimer -= DeltaTime;

     HandleDyingDriver();
    
     HandlePassenger();

     HandleLivingDriver();

     CheckForRoadKill(Other);

    if ((MSCarDriver != None) && (_flyingscreen != None))
     _flyingscreen.SetMessageText(GetDrivingStats());
//  }  
}
	function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		local float avg;

		if (bStatic || bInvincible)
			return;

		if ((DamageType == 'TearGas') || (DamageType == 'PoisonGas') || (DamageType == 'Radiation'))
			return;

		if ((DamageType == 'EMP') || (DamageType == 'NanoVirus') || (DamageType == 'Shocked'))
			return;

		if (DamageType == 'HalonGas')
			ExtinguishFire();

		if ((DamageType == 'Burned') || (DamageType == 'Flamed'))
		{
			if (bExplosive)		// blow up if we are hit by fire
				HitPoints = 0;
			else if (bFlammable && !Region.Zone.bWaterZone)
			{
				GotoState('Burning');
				return;
			}
		}

		if (Damage >= minDamageThreshold)
			HitPoints -= Damage;
		else
		{
			// sabot damage at 50%
			// explosion damage at 25%
			if (damageType == 'Sabot')
				HitPoints -= Damage * 0.5;
			else if (damageType == 'Exploded')
				HitPoints -= Damage * 0.25;
		}

		if (HitPoints > 0)		// darken it to show damage (from 1.0 to 0.1 - don't go completely black)
		{
			ResetScaleGlow();
		}
		else	// destroy it!
		{
			DropThings();

			// clear the event to keep Destroyed() from triggering the event
			Event = '';
			avg = (CollisionRadius + CollisionHeight) / 2;
			Instigator = EventInstigator;
			if (Instigator != None)
				MakeNoise(1.0);

			if (fragType == class'WoodFragment')
			{
				if (avg > 20)
					PlaySound(sound'WoodBreakLarge', SLOT_Misc,,, 512);
				else
					PlaySound(sound'WoodBreakSmall', SLOT_Misc,,, 512);
				AISendEvent('LoudNoise', EAITYPE_Audio, , 512);
			}

			// if we have been blown up, then destroy our contents
			// CNN - don't destroy contents now
//			if (DamageType == 'Exploded')
//			{
//				Contents = None;
//				Content2 = None;
//				Content3 = None;
//			}

			if (bExplosive)
			{
				Frag(fragType, Momentum * explosionRadius / 4, avg/35.0, avg/10 + 1);
				Explode(HitLocation);
			}
			else
				Frag(fragType, Momentum / 10, avg/20.0, avg/5 + 1);
		}
          	if (Damage >= 1)
		{
                        if (DamageSpots[DamageSpotCount] != None)
                         DamageSpots[DamageSpotCount].DelayedDestroy();

		    	DamageSpots[DamageSpotCount] = Spawn(class'ParticleGenerator', Self,, HitLocation);
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Sabot'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.123;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType == 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = Damage / 50;
				DamageSpots[DamageSpotCount].checkTime = 0.025;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
			if ((DamageSpots[DamageSpotCount] != None) && (DamageType != 'Sabot') && (DamageType != 'Exploded'))
			{
     				DamageSpots[DamageSpotCount].RemoteRole = ROLE_None;
				DamageSpots[DamageSpotCount].particleTexture = Texture'Effects.Fire.Fireball1';
				DamageSpots[DamageSpotCount].particleDrawScale = 0.09;
				DamageSpots[DamageSpotCount].checkTime = 0.035;
				DamageSpots[DamageSpotCount].riseRate = 0.0;
				DamageSpots[DamageSpotCount].ejectSpeed = 0.0;
				DamageSpots[DamageSpotCount].particleLifeSpan = 0.1;
				DamageSpots[DamageSpotCount].bRandomEject = True;
				DamageSpots[DamageSpotCount].SetBase(Self);
				DamageSpotCount += 1;
                                if (DamageSpotCount > 9) DamageSpotCount = 0; //dont let it exceed the array count
			}
                	if ((Damage >= 25) || (HitPoints < Default.HitPoints / 2))
			{
				Frag(fragType, Momentum / 10, avg/30.0, avg/5 + 1);
			}
		}
	}
}

simulated function string GetDrivingStats() //to be overridden in custom classes such as helicopters and whatnot 
{
 local string StatsMessage;
 
 StatsMessage = "Current Speed:"$MSCarSpeed * 360000 /16 /5280$" MPH, Gas Left: "$GasLeft / 50000$",|n Stats _/10: 1.Speed:"$CarSpeed$",2.Accel:"$MSAccelerationSpeed$",3.Gas:"$TopGas$",|n4.Strength:"$BrakeStrength$", Weapon: "$LeftGun.GunName$", |nAmmoLeft: "$(LeftGun.AmmoLeft + RightGun.AmmoLeft) / LeftGun.NumberOfShots$", Elevation:"$Location.Z - GarageLocation.Z$"|n Bombs Left:"$BombsLeft$", Gun Rotation:"$(LeftGun.Rotation.Pitch - LeftGun.AttachmentRotation.Pitch) / 92.555555$"";
 
 return StatsMessage;
}

simulated function MSFlyUpward()
{

 if (GasLeft > 0)
 {
    if (Physics != PHYS_Projectile)
   SetPhysics(PHYS_Projectile);

    if ((Location.Z - GarageLocation.Z <= 500 * BrakeStrength) && (StallTimer <= 0))
    {
             CurrentDrivableSpeed = Velocity; //get current speed
             CurrentDrivableSpeed += vect(0,0,1) * ((MSAccelerationSpeed - (2.5 / BrakeStrength))* 6.5); //made it calculate for strength and speed now
	     Velocity -= Velocity; // set speed to zero for a split second
	     Velocity += CurrentDrivableSpeed; // add the old speed plus a little extra
    }
    if (Location.Z - GarageLocation.Z > 500 * BrakeStrength)
    {
             CurrentDrivableSpeed = Velocity; //get current speed
             CurrentDrivableSpeed -= vect(0,0,1) * (Location.Z - GarageLocation.Z) / BrakeStrength; //depneding on how strong your copter is, youll go falling downward
	     Velocity -= Velocity; // set speed to zero for a split second
	     Velocity += CurrentDrivableSpeed; // add the old speed plus a little extra
             StallTimer += 11 - BrakeStrength; //stall out the engine
    }
    LastGasTimer = 0.500000; //notify the car that we're still on the gas
 }
}

simulated function MSFlyDownward()
{

 if (GasLeft > 0)
 {
    if (Physics != PHYS_Projectile)
   SetPhysics(PHYS_Projectile);

    if (GarageLocation.Z + Location.Z >= 500 * BrakeStrength * -1)
    {
             CurrentDrivableSpeed = Velocity; //get current speed
             CurrentDrivableSpeed += (vect(0,0,-1) * ((MSAccelerationSpeed - (2.5 / BrakeStrength))* 6.5)); //made it calculate for strength and speed now
	     Velocity -= Velocity; // set speed to zero for a split second
	     Velocity += CurrentDrivableSpeed; // add the old speed plus a little extra
    }
    if (GarageLocation.Z + Location.Z < 500 * BrakeStrength * -1)
    {
    MSCarDriver.SetLocation(Self.Location + (vect(1,0,0) * (CollisionRadius + MSCarDriver.CollisionRadius * 1.5))); 
    MSCarDriver.StartWalk();
//    MSCarDriver.ViewTarget = None;
//    MSCarDriver.bBehindView = False;
    MSCarDriver = None;
    SetOwner(None);
    if (MSCarPassenger != None)
    {
     MSCarPassenger.SetLocation(Self.Location + (vect(1,0,0) * (CollisionRadius + MSCarPassenger.CollisionRadius * 1.5))); 
     MSCarPassenger = None;
    }
    bBlockActors = True;
    //_FlyingScreen.root.PopWindow();
    _flyingScreen = None;
    SetPhysics(PHYS_Falling); //added because the car floats in the air otherwise...
    bInvincible = false;
    Explode(Location);
    }
    LastGasTimer = 0.500000; //notify the car that we're still on the gas
 }
}

//Warning, the following function is part cockjoke...

simulated function BlowTheLoad()
{
  local DeusExProjectile proj;

   if ((Location.Z > GarageLocation.Z) && (BombTimer <= 0) && (BombsLeft > 0) && (HasBombs))
   {
    proj = DeusExProjectile(Spawn(BombType, MSCarDriver,, Location - (vect(0,0,1) * (CollisionHeight + 34)), Rotation + BombRotation));
    BombTimer = BombTime;
    BombsLeft -= 1;
   }
}

defaultproperties
{
     HasBombs=True
     BombType=Class'DeusEx.RocketLaw'
     MaxBombs=10
     bExplosive=True
     bOwnerNoSee=True
     explosionRadius=750
     explosionDamage=175
     BombRotation=(Pitch=-16660,Yaw=0,Roll=0)
     FlyingScreenType=Class'MSDriving1_2.MenuUIFlyingWindow'
     MPFlyingScreenType=Class'MSDriving1_2.MPMenuUIFlyingWindow'
     VehicleRespawnTime=30.000000
     BombTime=2.500000
     MPFiringSound=Sound'MSDriving1_2.Weapons.AK47Fire'
     ShotTime=0.100000
     MPProjectileClass=Class'MSDriving1_2.RedBullet'
     KnownGuns(0)=Class'MSDriving1_2.DrivableWeaponAssaultGun'
     KnownGuns(1)=Class'MSDriving1_2.DrivableWeaponAssaultGun'
     KnownGuns(2)=Class'MSDriving1_2.DrivableWeaponAssaultGun'
     KnownGuns(3)=Class'MSDriving1_2.DrivableWeaponAssaultGun'
}
